/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.media.j3d.AlternateAppearanceRetained;
import javax.media.j3d.AmbientLightRetained;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.ClipRetained;
import javax.media.j3d.FogRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.LightRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.OrderedGroupRetained;
import javax.media.j3d.OrientedShape3DRetained;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.UnorderList;
import javax.media.j3d.UpdateTargets;
import javax.media.j3d.View;
import javax.media.j3d.ViewSpecificGroupRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Vector3d;

class RenderingEnvironmentStructure
extends J3dStructure
implements ObjectUpdate {
    ArrayList nonViewScopedLights = new ArrayList();
    HashMap viewScopedLights = new HashMap();
    int numberOfLights = 0;
    ArrayList nonViewScopedFogs = new ArrayList();
    HashMap viewScopedFogs = new HashMap();
    int numberOfFogs = 0;
    ArrayList nonViewScopedAltAppearances = new ArrayList();
    HashMap viewScopedAltAppearances = new HashMap();
    int numberOfAltApps = 0;
    ArrayList nonViewScopedModelClips = new ArrayList();
    HashMap viewScopedModelClips = new HashMap();
    int numberOfModelClips = 0;
    ArrayList nonViewScopedBackgrounds = new ArrayList();
    HashMap viewScopedBackgrounds = new HashMap();
    int numberOfBgs = 0;
    ArrayList nonViewScopedClips = new ArrayList();
    HashMap viewScopedClips = new HashMap();
    int numberOfClips = 0;
    BackgroundRetained[] intersectedBacks = new BackgroundRetained[1];
    ClipRetained[] intersectedClips = new ClipRetained[1];
    Bounds[] intersectedBounds = new Bounds[1];
    Transform3D localeXform = new Transform3D();
    Vector3d localeTranslation = new Vector3d();
    Bounds localeBounds = null;
    FogRetained[] intersectedFogs = new FogRetained[1];
    AlternateAppearanceRetained[] intersectedAltApps = new AlternateAppearanceRetained[1];
    ModelClipRetained[] intersectedModelClips = new ModelClipRetained[1];
    double backClipDistance;
    ArrayList objList = new ArrayList();
    ArrayList xformChangeList = new ArrayList();
    ArrayList objFreeList = new ArrayList();
    LightRetained[] retlights = new LightRetained[5];
    boolean transformMsg = false;
    UpdateTargets targets = null;
    ArrayList blUsers = null;
    Integer ogInsert = new Integer(32);
    Integer ogRemove = new Integer(33);
    Object lockObj = new Object();

    RenderingEnvironmentStructure(VirtualUniverse virtualUniverse) {
        super(virtualUniverse, 4096);
    }

    Object[] getObjectArray() {
        Object[] objectArray;
        int n2 = this.objFreeList.size();
        if (n2 == 0) {
            objectArray = new Object[5];
        } else {
            objectArray = (Object[])this.objFreeList.get(n2 - 1);
            this.objFreeList.remove(n2 - 1);
        }
        return objectArray;
    }

    void addObjArrayToFreeList(Object[] objectArray) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = null;
        }
        this.objFreeList.add(objectArray);
    }

    public void updateObject() {
        LeafRetained leafRetained;
        int n2;
        int n3 = this.objList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            Object[] objectArray = (Object[])this.objList.get(n2);
            leafRetained = (LeafRetained)objectArray[0];
            leafRetained.updateMirrorObject(objectArray);
            this.addObjArrayToFreeList(objectArray);
        }
        this.objList.clear();
        n3 = this.xformChangeList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            leafRetained = (LeafRetained)this.xformChangeList.get(n2);
            leafRetained.updateTransformChange();
        }
        this.xformChangeList.clear();
    }

    void processMessages(long l2) {
        Object[] objectArray = this.getMessages(l2);
        int n2 = this.getNumMessage();
        if (n2 <= 0) {
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            J3dMessage j3dMessage = objectArray[i2];
            switch (j3dMessage.type) {
                case 0: {
                    this.insertNodes(j3dMessage);
                    break;
                }
                case 1: {
                    this.removeNodes(j3dMessage);
                    break;
                }
                case 19: {
                    this.updateLight(j3dMessage.args);
                    break;
                }
                case 23: {
                    this.updateBoundingLeaf(j3dMessage.args);
                    break;
                }
                case 22: {
                    this.updateFog(j3dMessage.args);
                    break;
                }
                case 41: {
                    this.updateAltApp(j3dMessage.args);
                    break;
                }
                case 24: {
                    this.updateShape3D(j3dMessage.args);
                    break;
                }
                case 46: {
                    this.updateOrientedShape3D(j3dMessage.args);
                    break;
                }
                case 16: {
                    this.updateMorph(j3dMessage.args);
                    break;
                }
                case 3: {
                    this.transformMsg = true;
                    break;
                }
                case 27: {
                    this.processSwitchChanged(j3dMessage);
                    if (!this.universe.transformStructure.getLazyUpdate()) break;
                    this.transformMsg = true;
                    break;
                }
                case 36: {
                    this.updateModelClip(j3dMessage.args);
                    break;
                }
                case 20: {
                    this.updateBackground(j3dMessage.args);
                    break;
                }
                case 21: {
                    this.updateClip(j3dMessage.args);
                    break;
                }
                case 32: {
                    this.updateOrderedGroupInserted(j3dMessage);
                    break;
                }
                case 33: {
                    this.updateOrderedGroupsRemoved(j3dMessage);
                    break;
                }
                case 56: {
                    this.updateViewSpecificGroupChanged(j3dMessage);
                    break;
                }
                case 57: {
                    this.initViewSpecificInfo(j3dMessage);
                    break;
                }
                case 58: {
                    this.clearViewSpecificInfo(j3dMessage);
                }
            }
            j3dMessage.decRefcount();
        }
        if (this.transformMsg) {
            this.updateTransformChange();
            this.transformMsg = false;
        }
        VirtualUniverse.mc.addMirrorObject(this);
        Arrays.fill(objectArray, 0, n2, null);
    }

    void updateOrderedGroupInserted(J3dMessage j3dMessage) {
        Object[] objectArray = (Object[])j3dMessage.args[0];
        Object[] objectArray2 = (Object[])j3dMessage.args[1];
        Object[] objectArray3 = (Object[])j3dMessage.args[2];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            OrderedGroupRetained orderedGroupRetained = (OrderedGroupRetained)objectArray[i2];
            orderedGroupRetained.updateChildIdTableInserted((Integer)objectArray2[i2], (Integer)objectArray3[i2]);
            orderedGroupRetained.incrChildCount();
        }
    }

    void updateOrderedGroupsRemoved(J3dMessage j3dMessage) {
        Object[] objectArray = (Object[])j3dMessage.args[0];
        Object[] objectArray2 = (Object[])j3dMessage.args[1];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            OrderedGroupRetained orderedGroupRetained = (OrderedGroupRetained)objectArray[i2];
            orderedGroupRetained.updateChildIdTableRemoved((Integer)objectArray2[i2]);
            orderedGroupRetained.decrChildCount();
        }
    }

    void processSwitchChanged(J3dMessage j3dMessage) {
        UpdateTargets updateTargets = (UpdateTargets)j3dMessage.args[0];
        UnorderList unorderList = updateTargets.targetList[5];
        if (unorderList != null) {
            Object[] objectArray = (Object[])j3dMessage.args[1];
            int n2 = unorderList.size();
            Object[] objectArray2 = unorderList.toArray(false);
            for (int i2 = 0; i2 < n2; ++i2) {
                Object[] objectArray3 = (Object[])objectArray2[i2];
                Object[] objectArray4 = (Object[])objectArray[i2];
                for (int i3 = 0; i3 < objectArray3.length; ++i3) {
                    Object[] objectArray5 = (Object[])objectArray4[i3];
                    BoundingLeafRetained boundingLeafRetained = (BoundingLeafRetained)objectArray3[i3];
                    for (int i4 = 0; i4 < objectArray5.length; ++i4) {
                        LeafRetained leafRetained = (LeafRetained)objectArray5[i4];
                        if (!(leafRetained instanceof FogRetained) && !(leafRetained instanceof LightRetained) && !(leafRetained instanceof ModelClipRetained) && !(leafRetained instanceof ClipRetained) && !(leafRetained instanceof AlternateAppearanceRetained) && !(leafRetained instanceof BackgroundRetained)) continue;
                        leafRetained.updateBoundingLeaf();
                    }
                }
            }
        }
    }

    void insertNodes(J3dMessage j3dMessage) {
        Object object;
        int n2;
        Object[] objectArray = (Object[])j3dMessage.args[0];
        ArrayList arrayList = (ArrayList)j3dMessage.args[3];
        ArrayList arrayList2 = (ArrayList)j3dMessage.args[4];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            LeafRetained leafRetained;
            object = objectArray[n2];
            if (object instanceof LightRetained) {
                LightRetained lightRetained = (LightRetained)object;
                ++this.numberOfLights;
                if (lightRetained.inBackgroundGroup) {
                    lightRetained.geometryBackground.lights.add(lightRetained);
                    continue;
                }
                this.nonViewScopedLights.add(lightRetained);
                continue;
            }
            if (object instanceof FogRetained) {
                FogRetained fogRetained = (FogRetained)object;
                ++this.numberOfFogs;
                if (fogRetained.inBackgroundGroup) {
                    fogRetained.geometryBackground.fogs.add(fogRetained);
                    continue;
                }
                this.nonViewScopedFogs.add(fogRetained);
                continue;
            }
            if (object instanceof AlternateAppearanceRetained) {
                leafRetained = (AlternateAppearanceRetained)object;
                ++this.numberOfAltApps;
                this.nonViewScopedAltAppearances.add(object);
                continue;
            }
            if (object instanceof BackgroundRetained) {
                leafRetained = (BackgroundRetained)object;
                ++this.numberOfBgs;
                this.nonViewScopedBackgrounds.add(object);
                continue;
            }
            if (object instanceof ClipRetained) {
                leafRetained = (ClipRetained)object;
                ++this.numberOfClips;
                this.nonViewScopedClips.add(object);
                continue;
            }
            if (!(object instanceof ModelClipRetained)) continue;
            ModelClipRetained modelClipRetained = (ModelClipRetained)object;
            ++this.numberOfModelClips;
            this.nonViewScopedModelClips.add(object);
        }
        if (arrayList != null) {
            int n3 = arrayList.size();
            for (n2 = 0; n2 < n3; ++n2) {
                ArrayList arrayList3;
                View view;
                int n4;
                int n5;
                object = (NodeRetained)arrayList.get(n2);
                ArrayList arrayList4 = (ArrayList)arrayList2.get(n2);
                if (object instanceof LightRetained) {
                    ((LightRetained)object).isViewScoped = true;
                    ++this.numberOfLights;
                    n5 = arrayList4.size();
                    for (n4 = 0; n4 < n5; ++n4) {
                        view = (View)arrayList4.get(n4);
                        arrayList3 = (ArrayList)this.viewScopedLights.get(view);
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList();
                            this.viewScopedLights.put(view, arrayList3);
                        }
                        arrayList3.add(object);
                    }
                    continue;
                }
                if (object instanceof FogRetained) {
                    ((FogRetained)object).isViewScoped = true;
                    ++this.numberOfFogs;
                    n5 = arrayList4.size();
                    for (n4 = 0; n4 < n5; ++n4) {
                        view = (View)arrayList4.get(n4);
                        arrayList3 = (ArrayList)this.viewScopedFogs.get(view);
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList();
                            this.viewScopedFogs.put(view, arrayList3);
                        }
                        arrayList3.add(object);
                    }
                    continue;
                }
                if (object instanceof AlternateAppearanceRetained) {
                    ((AlternateAppearanceRetained)object).isViewScoped = true;
                    ++this.numberOfAltApps;
                    n5 = arrayList4.size();
                    for (n4 = 0; n4 < n5; ++n4) {
                        view = (View)arrayList4.get(n4);
                        arrayList3 = (ArrayList)this.viewScopedAltAppearances.get(view);
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList();
                            this.viewScopedAltAppearances.put(view, arrayList3);
                        }
                        arrayList3.add(object);
                    }
                    continue;
                }
                if (object instanceof BackgroundRetained) {
                    ((BackgroundRetained)object).isViewScoped = true;
                    ++this.numberOfBgs;
                    n5 = arrayList4.size();
                    for (n4 = 0; n4 < n5; ++n4) {
                        view = (View)arrayList4.get(n4);
                        arrayList3 = (ArrayList)this.viewScopedBackgrounds.get(view);
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList();
                            this.viewScopedBackgrounds.put(view, arrayList3);
                        }
                        arrayList3.add(object);
                    }
                    continue;
                }
                if (object instanceof ClipRetained) {
                    ((ClipRetained)object).isViewScoped = true;
                    ++this.numberOfClips;
                    n5 = arrayList4.size();
                    for (n4 = 0; n4 < n5; ++n4) {
                        view = (View)arrayList4.get(n4);
                        arrayList3 = (ArrayList)this.viewScopedClips.get(view);
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList();
                            this.viewScopedClips.put(view, arrayList3);
                        }
                        arrayList3.add(object);
                    }
                    continue;
                }
                if (!(object instanceof ModelClipRetained)) continue;
                ((ModelClipRetained)object).isViewScoped = true;
                ++this.numberOfModelClips;
                n5 = arrayList4.size();
                for (n4 = 0; n4 < n5; ++n4) {
                    view = (View)arrayList4.get(n4);
                    arrayList3 = (ArrayList)this.viewScopedModelClips.get(view);
                    if (arrayList3 == null) {
                        arrayList3 = new ArrayList();
                        this.viewScopedModelClips.put(view, arrayList3);
                    }
                    arrayList3.add(object);
                }
            }
        }
        if (this.numberOfLights > this.retlights.length) {
            this.retlights = new LightRetained[this.numberOfLights];
        }
        if (this.intersectedFogs.length < this.numberOfFogs) {
            this.intersectedFogs = new FogRetained[this.numberOfFogs];
        }
        if (this.intersectedAltApps.length < this.numberOfAltApps) {
            this.intersectedAltApps = new AlternateAppearanceRetained[this.numberOfAltApps];
        }
        if (this.intersectedBacks.length < this.numberOfBgs) {
            this.intersectedBacks = new BackgroundRetained[this.numberOfBgs];
        }
        if (this.intersectedClips.length < this.numberOfClips) {
            this.intersectedClips = new ClipRetained[this.numberOfClips];
        }
        if (this.intersectedModelClips.length < this.numberOfModelClips) {
            this.intersectedModelClips = new ModelClipRetained[this.numberOfModelClips];
        }
    }

    void removeNodes(J3dMessage j3dMessage) {
        Object object;
        int n2;
        Object[] objectArray = (Object[])j3dMessage.args[0];
        ArrayList arrayList = (ArrayList)j3dMessage.args[3];
        ArrayList arrayList2 = (ArrayList)j3dMessage.args[4];
        Shape3DRetained shape3DRetained = null;
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            LeafRetained leafRetained;
            object = objectArray[n2];
            if (object instanceof LightRetained) {
                leafRetained = (LightRetained)object;
                if (leafRetained.inBackgroundGroup) {
                    leafRetained.geometryBackground.lights.remove(leafRetained);
                } else {
                    this.nonViewScopedLights.remove(this.nonViewScopedLights.indexOf(object));
                }
                --this.numberOfLights;
                continue;
            }
            if (object instanceof FogRetained) {
                --this.numberOfFogs;
                leafRetained = (FogRetained)object;
                if (((FogRetained)leafRetained).inBackgroundGroup) {
                    ((FogRetained)leafRetained).geometryBackground.fogs.remove(leafRetained);
                    continue;
                }
                this.nonViewScopedFogs.remove(this.nonViewScopedFogs.indexOf(object));
                continue;
            }
            if (object instanceof AlternateAppearanceRetained) {
                --this.numberOfAltApps;
                this.nonViewScopedAltAppearances.remove(this.nonViewScopedAltAppearances.indexOf(object));
                continue;
            }
            if (object instanceof BackgroundRetained) {
                --this.numberOfBgs;
                this.nonViewScopedBackgrounds.remove(this.nonViewScopedBackgrounds.indexOf(object));
                continue;
            }
            if (object instanceof ClipRetained) {
                --this.numberOfClips;
                this.nonViewScopedClips.remove(this.nonViewScopedClips.indexOf(object));
                continue;
            }
            if (object instanceof ModelClipRetained) {
                leafRetained = (ModelClipRetained)object;
                --this.numberOfModelClips;
                this.nonViewScopedModelClips.remove(this.nonViewScopedModelClips.indexOf(object));
                continue;
            }
            if (object instanceof GeometryAtom) {
                GeometryAtom geometryAtom = (GeometryAtom)object;
                if (geometryAtom.source == shape3DRetained) continue;
                geometryAtom.source.clearMirrorShape();
                shape3DRetained = geometryAtom.source;
                continue;
            }
            if (!(object instanceof OrderedGroupRetained)) continue;
            ((OrderedGroupRetained)object).clearDerivedDataStructures();
        }
        if (arrayList != null) {
            int n3 = arrayList.size();
            for (n2 = 0; n2 < n3; ++n2) {
                ArrayList arrayList3;
                View view;
                int n4;
                int n5;
                object = (NodeRetained)arrayList.get(n2);
                ArrayList arrayList4 = (ArrayList)arrayList2.get(n2);
                if (object instanceof LightRetained) {
                    ((LightRetained)object).isViewScoped = false;
                    --this.numberOfLights;
                    n5 = arrayList4.size();
                    for (n4 = 0; n4 < n5; ++n4) {
                        view = (View)arrayList4.get(n4);
                        arrayList3 = (ArrayList)this.viewScopedLights.get(view);
                        arrayList3.remove(object);
                        if (arrayList3.size() != 0) continue;
                        this.viewScopedLights.remove(view);
                    }
                    continue;
                }
                if (object instanceof FogRetained) {
                    ((FogRetained)object).isViewScoped = false;
                    --this.numberOfFogs;
                    n5 = arrayList4.size();
                    for (n4 = 0; n4 < n5; ++n4) {
                        view = (View)arrayList4.get(n4);
                        arrayList3 = (ArrayList)this.viewScopedFogs.get(view);
                        arrayList3.remove(object);
                        if (arrayList3.size() != 0) continue;
                        this.viewScopedFogs.remove(view);
                    }
                    continue;
                }
                if (object instanceof AlternateAppearanceRetained) {
                    ((AlternateAppearanceRetained)object).isViewScoped = false;
                    --this.numberOfAltApps;
                    n5 = arrayList4.size();
                    for (n4 = 0; n4 < n5; ++n4) {
                        view = (View)arrayList4.get(n4);
                        arrayList3 = (ArrayList)this.viewScopedAltAppearances.get(view);
                        arrayList3.remove(object);
                        if (arrayList3.size() != 0) continue;
                        this.viewScopedAltAppearances.remove(view);
                    }
                    continue;
                }
                if (object instanceof BackgroundRetained) {
                    ((BackgroundRetained)object).isViewScoped = false;
                    --this.numberOfBgs;
                    n5 = arrayList4.size();
                    for (n4 = 0; n4 < n5; ++n4) {
                        view = (View)arrayList4.get(n4);
                        arrayList3 = (ArrayList)this.viewScopedBackgrounds.get(view);
                        arrayList3.remove(object);
                        if (arrayList3.size() != 0) continue;
                        this.viewScopedBackgrounds.remove(view);
                    }
                    continue;
                }
                if (object instanceof ClipRetained) {
                    ((ClipRetained)object).isViewScoped = false;
                    --this.numberOfClips;
                    n5 = arrayList4.size();
                    for (n4 = 0; n4 < n5; ++n4) {
                        view = (View)arrayList4.get(n4);
                        arrayList3 = (ArrayList)this.viewScopedClips.get(view);
                        arrayList3.remove(object);
                        if (arrayList3.size() != 0) continue;
                        this.viewScopedClips.remove(view);
                    }
                    continue;
                }
                if (!(object instanceof ModelClipRetained)) continue;
                ((ModelClipRetained)object).isViewScoped = false;
                --this.numberOfModelClips;
                n5 = arrayList4.size();
                for (n4 = 0; n4 < n5; ++n4) {
                    view = (View)arrayList4.get(n4);
                    arrayList3 = (ArrayList)this.viewScopedModelClips.get(view);
                    arrayList3.remove(object);
                    if (arrayList3.size() != 0) continue;
                    this.viewScopedModelClips.remove(view);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LightRetained[] getInfluencingLights(RenderAtom renderAtom, View view) {
        LightRetained[] lightRetainedArray = null;
        LightRetained[] lightRetainedArray2 = this.retlights;
        synchronized (this.retlights) {
            int n2;
            ArrayList arrayList;
            int n3 = 0;
            if (renderAtom.geometryAtom.source.inBackgroundGroup) {
                arrayList = renderAtom.geometryAtom.source.geometryBackground.lights;
                n3 = this.processLights(arrayList, renderAtom, n3);
            } else {
                arrayList = (ArrayList)this.viewScopedLights.get(view);
                if (arrayList != null) {
                    n3 = this.processLights(arrayList, renderAtom, n3);
                }
                n3 = this.processLights(this.nonViewScopedLights, renderAtom, n3);
            }
            boolean bl = false;
            if (renderAtom.lights != null && renderAtom.lights.length == n3) {
                for (n2 = 0; n2 < renderAtom.lights.length; ++n2) {
                    int n4;
                    for (n4 = 0; n4 < n3 && renderAtom.lights[n2] != this.retlights[n4]; ++n4) {
                    }
                    if (n4 != n3) continue;
                    bl = true;
                    break;
                }
            } else {
                bl = true;
            }
            if (bl) {
                lightRetainedArray = new LightRetained[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    lightRetainedArray[n2] = this.retlights[n2];
                }
                // ** MonitorExit[var9_4] (shouldn't be in output)
                return lightRetainedArray;
            }
            // ** MonitorExit[var9_4] (shouldn't be in output)
            return renderAtom.lights;
        }
    }

    int processLights(ArrayList arrayList, RenderAtom renderAtom, int n2) {
        BoundingBox boundingBox = renderAtom.localeVwcBounds;
        int n3 = arrayList.size();
        if (n3 > 0) {
            block0: for (int i2 = 0; i2 < n3; ++i2) {
                LightRetained lightRetained = (LightRetained)arrayList.get(i2);
                if (!lightRetained.lightOn || !lightRetained.switchState.currentSwitchOn || !renderAtom.geometryAtom.source.inBackgroundGroup && !((Bounds)boundingBox).intersect(lightRetained.region)) continue;
                int n4 = renderAtom.geometryAtom.source.numlights;
                LightRetained[] lightRetainedArray = renderAtom.geometryAtom.source.lights;
                if (lightRetained.isScoped) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        if (lightRetained != lightRetainedArray[i3]) continue;
                        this.retlights[n2++] = lightRetained;
                        continue block0;
                    }
                    continue;
                }
                this.retlights[n2++] = lightRetained;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FogRetained getInfluencingFog(RenderAtom renderAtom, View view) {
        FogRetained fogRetained = null;
        Object object = this.lockObj;
        synchronized (object) {
            block10: {
                BoundingBox boundingBox;
                int n2;
                block9: {
                    n2 = 0;
                    boundingBox = renderAtom.localeVwcBounds;
                    if (this.intersectedBounds.length < this.numberOfFogs) {
                        this.intersectedBounds = new Bounds[this.numberOfFogs];
                    }
                    if (!renderAtom.geometryAtom.source.inBackgroundGroup) break block9;
                    ArrayList arrayList = renderAtom.geometryAtom.source.geometryBackground.fogs;
                    if ((n2 = this.processFogs(arrayList, renderAtom, n2)) < 1) break block10;
                    fogRetained = this.intersectedFogs[0];
                    break block10;
                }
                ArrayList arrayList = (ArrayList)this.viewScopedFogs.get(view);
                if (arrayList != null) {
                    n2 = this.processFogs(arrayList, renderAtom, n2);
                }
                if ((n2 = this.processFogs(this.nonViewScopedFogs, renderAtom, n2)) == 1) {
                    fogRetained = this.intersectedFogs[0];
                } else if (n2 > 1) {
                    Bounds bounds = ((Bounds)boundingBox).closestIntersection(this.intersectedBounds);
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (this.intersectedBounds[i2] != bounds) continue;
                        fogRetained = this.intersectedFogs[i2];
                        break;
                    }
                }
            }
            return fogRetained;
        }
    }

    int processFogs(ArrayList arrayList, RenderAtom renderAtom, int n2) {
        int n3 = arrayList.size();
        BoundingBox boundingBox = renderAtom.localeVwcBounds;
        if (arrayList.size() > 0) {
            block0: for (int i2 = 0; i2 < n3; ++i2) {
                FogRetained fogRetained = (FogRetained)arrayList.get(i2);
                if (fogRetained.region == null || !fogRetained.switchState.currentSwitchOn || !renderAtom.geometryAtom.source.inBackgroundGroup && !fogRetained.region.intersect(boundingBox)) continue;
                int n4 = renderAtom.geometryAtom.source.numfogs;
                FogRetained[] fogRetainedArray = renderAtom.geometryAtom.source.fogs;
                if (fogRetained.isScoped) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        if (fogRetained != fogRetainedArray[i3]) continue;
                        this.intersectedBounds[n2] = fogRetained.region;
                        this.intersectedFogs[n2++] = fogRetained;
                        continue block0;
                    }
                    continue;
                }
                this.intersectedBounds[n2] = fogRetained.region;
                this.intersectedFogs[n2++] = fogRetained;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ModelClipRetained getInfluencingModelClip(RenderAtom renderAtom, View view) {
        ModelClipRetained modelClipRetained = null;
        if (renderAtom.geometryAtom.source.inBackgroundGroup) {
            return null;
        }
        Object object = this.lockObj;
        synchronized (object) {
            ArrayList arrayList;
            BoundingBox boundingBox = renderAtom.localeVwcBounds;
            int n2 = 0;
            if (this.intersectedBounds.length < this.numberOfModelClips) {
                this.intersectedBounds = new Bounds[this.numberOfModelClips];
            }
            if ((arrayList = (ArrayList)this.viewScopedModelClips.get(view)) != null) {
                n2 = this.processModelClips(arrayList, renderAtom, n2);
            }
            n2 = this.processModelClips(this.nonViewScopedModelClips, renderAtom, n2);
            modelClipRetained = null;
            if (n2 == 1) {
                modelClipRetained = this.intersectedModelClips[0];
            } else if (n2 > 1) {
                Bounds bounds = ((Bounds)boundingBox).closestIntersection(this.intersectedBounds);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.intersectedBounds[i2] != bounds) continue;
                    modelClipRetained = this.intersectedModelClips[i2];
                    break;
                }
            }
            return modelClipRetained;
        }
    }

    int processModelClips(ArrayList arrayList, RenderAtom renderAtom, int n2) {
        int n3 = arrayList.size();
        BoundingBox boundingBox = renderAtom.localeVwcBounds;
        if (n3 > 0) {
            block0: for (int i2 = 0; i2 < n3; ++i2) {
                ModelClipRetained modelClipRetained = (ModelClipRetained)arrayList.get(i2);
                if (!modelClipRetained.enableFlag || modelClipRetained.region == null || !modelClipRetained.switchState.currentSwitchOn || !modelClipRetained.region.intersect(boundingBox)) continue;
                int n4 = renderAtom.geometryAtom.source.numModelClips;
                ModelClipRetained[] modelClipRetainedArray = renderAtom.geometryAtom.source.modelClips;
                if (modelClipRetained.isScoped) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        if (modelClipRetainedArray[i3] != modelClipRetained) continue;
                        this.intersectedBounds[n2] = modelClipRetained.region;
                        this.intersectedModelClips[n2++] = modelClipRetained;
                        continue block0;
                    }
                    continue;
                }
                this.intersectedBounds[n2] = modelClipRetained.region;
                this.intersectedModelClips[n2++] = modelClipRetained;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BackgroundRetained getApplicationBackground(BoundingSphere boundingSphere, Locale locale, View view) {
        BackgroundRetained backgroundRetained = null;
        boolean bl = false;
        int n2 = 0;
        Object object = this.lockObj;
        synchronized (object) {
            ArrayList arrayList;
            int n3 = 0;
            if (this.intersectedBounds.length < this.numberOfBgs) {
                this.intersectedBounds = new Bounds[this.numberOfBgs];
            }
            if ((arrayList = (ArrayList)this.viewScopedBackgrounds.get(view)) != null) {
                n3 = this.processBgs(arrayList, boundingSphere, n3, locale);
            }
            if ((n3 = this.processBgs(this.nonViewScopedBackgrounds, boundingSphere, n3, locale)) == 1) {
                backgroundRetained = this.intersectedBacks[0];
            } else if (n3 > 1) {
                Bounds bounds = boundingSphere.closestIntersection(this.intersectedBounds);
                for (n2 = 0; n2 < n3; ++n2) {
                    if (this.intersectedBounds[n2] != bounds) continue;
                    backgroundRetained = this.intersectedBacks[n2];
                    break;
                }
            }
            return backgroundRetained;
        }
    }

    int processBgs(ArrayList arrayList, BoundingSphere boundingSphere, int n2, Locale locale) {
        int n3 = arrayList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            BackgroundRetained backgroundRetained = (BackgroundRetained)arrayList.get(i2);
            if (backgroundRetained.transformedRegion == null || !backgroundRetained.switchState.currentSwitchOn) continue;
            if (backgroundRetained.cachedLocale != locale) {
                this.localeBounds = (Bounds)backgroundRetained.transformedRegion.clone();
                backgroundRetained.cachedLocale.hiRes.difference(locale.hiRes, this.localeTranslation);
                this.localeXform.setIdentity();
                this.localeXform.setTranslation(this.localeTranslation);
                this.localeBounds.transform(this.localeXform);
                if (!this.localeBounds.intersect(boundingSphere)) continue;
                this.intersectedBounds[n2] = this.localeBounds;
                this.intersectedBacks[n2++] = backgroundRetained;
                continue;
            }
            if (!backgroundRetained.transformedRegion.intersect(boundingSphere)) continue;
            this.intersectedBounds[n2] = backgroundRetained.transformedRegion;
            this.intersectedBacks[n2++] = backgroundRetained;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double[] backClipDistanceInVworld(BoundingSphere boundingSphere, View view) {
        Object object = this.lockObj;
        synchronized (object) {
            ArrayList arrayList;
            double[] dArray = null;
            boolean bl = false;
            int n2 = 0;
            double d2 = 0.0;
            if (this.intersectedBounds.length < this.numberOfClips) {
                this.intersectedBounds = new Bounds[this.numberOfClips];
            }
            if ((arrayList = (ArrayList)this.viewScopedClips.get(view)) != null) {
                n2 = this.processClips(arrayList, boundingSphere, n2);
            }
            if ((n2 = this.processClips(this.nonViewScopedClips, boundingSphere, n2)) == 1) {
                d2 = this.intersectedClips[0].backDistanceInVworld;
                bl = true;
            } else if (n2 > 1) {
                Bounds bounds = boundingSphere.closestIntersection(this.intersectedBounds);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.intersectedBounds[i2] != bounds) continue;
                    d2 = this.intersectedClips[i2].backDistanceInVworld;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                dArray = new double[]{d2};
            }
            return dArray;
        }
    }

    int processClips(ArrayList arrayList, BoundingSphere boundingSphere, int n2) {
        int n3 = arrayList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            ClipRetained clipRetained = (ClipRetained)arrayList.get(i2);
            if (clipRetained.transformedRegion == null || !clipRetained.transformedRegion.intersect(boundingSphere) || !clipRetained.switchState.currentSwitchOn) continue;
            this.intersectedBounds[n2] = clipRetained.transformedRegion;
            this.intersectedClips[n2++] = clipRetained;
        }
        return n2;
    }

    void updateLight(Object[] objectArray) {
        LightRetained lightRetained = (LightRetained)objectArray[0];
        int n2 = (Integer)objectArray[1];
        if ((n2 & 0x20) != 0) {
            lightRetained.initMirrorObject(objectArray);
        }
        if (lightRetained instanceof AmbientLightRetained && (n2 & 8) != 0) {
            lightRetained.updateImmediateMirrorObject(objectArray);
        } else if ((n2 & 0xFA8) != 0) {
            Object[] objectArray2 = this.getObjectArray();
            objectArray2[0] = objectArray[0];
            objectArray2[1] = objectArray[1];
            objectArray2[2] = objectArray[2];
            objectArray2[3] = objectArray[3];
            objectArray2[4] = objectArray[4];
            this.objList.add(objectArray2);
        } else if ((n2 & 0x40) != 0) {
            lightRetained.clearMirrorObject(objectArray);
        } else {
            lightRetained.updateImmediateMirrorObject(objectArray);
        }
    }

    void updateBackground(Object[] objectArray) {
        BackgroundRetained backgroundRetained = (BackgroundRetained)objectArray[0];
        backgroundRetained.updateImmediateMirrorObject(objectArray);
    }

    void updateFog(Object[] objectArray) {
        FogRetained fogRetained = (FogRetained)objectArray[0];
        int n2 = (Integer)objectArray[1];
        if ((n2 & 0x10) != 0) {
            fogRetained.initMirrorObject(objectArray);
            Object[] objectArray2 = this.getObjectArray();
            objectArray2[0] = objectArray[0];
            objectArray2[1] = objectArray[1];
            objectArray2[2] = objectArray[2];
            objectArray2[3] = objectArray[3];
            objectArray2[4] = objectArray[4];
            this.objList.add(objectArray2);
        } else if ((n2 & 0x20) != 0) {
            fogRetained.clearMirrorObject(objectArray);
        } else if ((n2 & 0xC1) != 0) {
            Object[] objectArray3 = this.getObjectArray();
            objectArray3[0] = objectArray[0];
            objectArray3[1] = objectArray[1];
            objectArray3[2] = objectArray[2];
            objectArray3[3] = objectArray[3];
            objectArray3[4] = objectArray[4];
            this.objList.add(objectArray3);
        } else {
            fogRetained.updateImmediateMirrorObject(objectArray);
        }
    }

    void updateAltApp(Object[] objectArray) {
        AlternateAppearanceRetained alternateAppearanceRetained = (AlternateAppearanceRetained)objectArray[0];
        int n2 = (Integer)objectArray[1];
        if ((n2 & 0x10) != 0) {
            AlternateAppearanceRetained alternateAppearanceRetained2 = (AlternateAppearanceRetained)objectArray[0];
            alternateAppearanceRetained2.initMirrorObject(objectArray);
        } else if ((n2 & 0x20) != 0) {
            AlternateAppearanceRetained alternateAppearanceRetained3 = (AlternateAppearanceRetained)objectArray[0];
            alternateAppearanceRetained3.clearMirrorObject(objectArray);
        } else {
            alternateAppearanceRetained.updateImmediateMirrorObject(objectArray);
        }
    }

    void updateClip(Object[] objectArray) {
        ClipRetained clipRetained = (ClipRetained)objectArray[0];
        clipRetained.updateImmediateMirrorObject(objectArray);
    }

    void updateModelClip(Object[] objectArray) {
        ModelClipRetained modelClipRetained = (ModelClipRetained)objectArray[0];
        int n2 = (Integer)objectArray[1];
        if ((n2 & 0x80) != 0) {
            modelClipRetained.initMirrorObject(objectArray);
        }
        if ((n2 & 0x100) != 0) {
            modelClipRetained.clearMirrorObject(objectArray);
        } else if ((n2 & 0x83) != 0) {
            Object[] objectArray2 = this.getObjectArray();
            objectArray2[0] = objectArray[0];
            objectArray2[1] = objectArray[1];
            objectArray2[2] = objectArray[2];
            objectArray2[3] = objectArray[3];
            objectArray2[4] = objectArray[4];
            this.objList.add(objectArray2);
        } else {
            modelClipRetained.updateImmediateMirrorObject(objectArray);
        }
    }

    void updateBoundingLeaf(Object[] objectArray) {
        BoundingLeafRetained boundingLeafRetained = (BoundingLeafRetained)objectArray[0];
        Object[] objectArray2 = (Object[])objectArray[3];
        boundingLeafRetained.updateImmediateMirrorObject(objectArray);
        for (int i2 = 0; i2 < objectArray2.length; ++i2) {
            LeafRetained leafRetained = (LeafRetained)objectArray2[i2];
            leafRetained.updateBoundingLeaf();
        }
    }

    void updateShape3D(Object[] objectArray) {
        Shape3DRetained shape3DRetained = (Shape3DRetained)objectArray[0];
        shape3DRetained.updateImmediateMirrorObject(objectArray);
    }

    void updateOrientedShape3D(Object[] objectArray) {
        OrientedShape3DRetained orientedShape3DRetained = (OrientedShape3DRetained)objectArray[4];
        orientedShape3DRetained.updateImmediateMirrorObject(objectArray);
    }

    void updateMorph(Object[] objectArray) {
        MorphRetained morphRetained = (MorphRetained)objectArray[0];
        morphRetained.updateImmediateMirrorObject(objectArray);
    }

    void updateTransformChange() {
        LeafRetained leafRetained;
        int n2;
        Object[] objectArray;
        int n3;
        Object[] objectArray2;
        int n4;
        this.targets = this.universe.transformStructure.getTargetList();
        this.blUsers = this.universe.transformStructure.getBlUsers();
        UnorderList unorderList = this.targets.targetList[1];
        if (unorderList != null) {
            n4 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            for (n3 = 0; n3 < n4; ++n3) {
                objectArray = (Object[])objectArray2[n3];
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    if (objectArray[n2] instanceof LightRetained) {
                        LightRetained lightRetained = (LightRetained)objectArray[n2];
                        lightRetained.updateImmediateTransformChange();
                        this.xformChangeList.add(objectArray[n2]);
                        continue;
                    }
                    if (objectArray[n2] instanceof FogRetained) {
                        leafRetained = (FogRetained)objectArray[n2];
                        ((FogRetained)leafRetained).updateImmediateTransformChange();
                        this.xformChangeList.add(objectArray[n2]);
                        continue;
                    }
                    if (objectArray[n2] instanceof AlternateAppearanceRetained) {
                        leafRetained = (AlternateAppearanceRetained)objectArray[n2];
                        ((AlternateAppearanceRetained)leafRetained).updateImmediateTransformChange();
                        this.xformChangeList.add(objectArray[n2]);
                        continue;
                    }
                    if (objectArray[n2] instanceof BackgroundRetained) {
                        leafRetained = (BackgroundRetained)objectArray[n2];
                        ((BackgroundRetained)leafRetained).updateImmediateTransformChange();
                        continue;
                    }
                    if (!(objectArray[n2] instanceof ModelClipRetained)) continue;
                    leafRetained = (ModelClipRetained)objectArray[n2];
                    ((ModelClipRetained)leafRetained).updateImmediateTransformChange();
                }
            }
        }
        if ((unorderList = this.targets.targetList[5]) != null) {
            n4 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            for (n3 = 0; n3 < n4; ++n3) {
                objectArray = (Object[])objectArray2[n3];
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    BoundingLeafRetained boundingLeafRetained = (BoundingLeafRetained)objectArray[n2];
                    boundingLeafRetained.updateImmediateTransformChange();
                }
            }
        }
        if (this.blUsers != null) {
            for (n2 = 0; n2 < this.blUsers.size(); ++n2) {
                leafRetained = (LeafRetained)this.blUsers.get(n2);
                leafRetained.updateBoundingLeaf();
            }
        }
        this.targets = null;
        this.blUsers = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] getInfluencingAppearance(RenderAtom renderAtom, View view) {
        AlternateAppearanceRetained alternateAppearanceRetained = null;
        Object[] objectArray = new Object[2];
        if (renderAtom.geometryAtom.source.inBackgroundGroup) {
            objectArray[0] = Boolean.FALSE;
            return objectArray;
        }
        Object object = this.lockObj;
        synchronized (object) {
            ArrayList arrayList;
            int n2 = 0;
            BoundingBox boundingBox = renderAtom.localeVwcBounds;
            if (this.intersectedBounds.length < this.numberOfAltApps) {
                this.intersectedBounds = new Bounds[this.numberOfAltApps];
            }
            if ((arrayList = (ArrayList)this.viewScopedAltAppearances.get(view)) != null) {
                n2 = this.processAltApps(arrayList, renderAtom, n2);
            }
            n2 = this.processAltApps(this.nonViewScopedAltAppearances, renderAtom, n2);
            alternateAppearanceRetained = null;
            if (n2 == 1) {
                alternateAppearanceRetained = this.intersectedAltApps[0];
            } else if (n2 > 1) {
                Bounds bounds = ((Bounds)boundingBox).closestIntersection(this.intersectedBounds);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.intersectedBounds[i2] != bounds) continue;
                    alternateAppearanceRetained = this.intersectedAltApps[i2];
                    break;
                }
            }
            if (alternateAppearanceRetained == null) {
                objectArray[0] = Boolean.FALSE;
                return objectArray;
            }
            objectArray[0] = Boolean.TRUE;
            objectArray[1] = alternateAppearanceRetained.appearance;
            return objectArray;
        }
    }

    int processAltApps(ArrayList arrayList, RenderAtom renderAtom, int n2) {
        int n3 = arrayList.size();
        BoundingBox boundingBox = renderAtom.localeVwcBounds;
        if (n3 > 0) {
            block0: for (int i2 = 0; i2 < n3; ++i2) {
                AlternateAppearanceRetained alternateAppearanceRetained = (AlternateAppearanceRetained)arrayList.get(i2);
                if (alternateAppearanceRetained.region == null || !alternateAppearanceRetained.switchState.currentSwitchOn || !alternateAppearanceRetained.region.intersect(boundingBox)) continue;
                int n4 = renderAtom.geometryAtom.source.numAltApps;
                AlternateAppearanceRetained[] alternateAppearanceRetainedArray = renderAtom.geometryAtom.source.altApps;
                if (alternateAppearanceRetained.isScoped) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        if (alternateAppearanceRetained != alternateAppearanceRetainedArray[i3]) continue;
                        this.intersectedBounds[n2] = alternateAppearanceRetained.region;
                        this.intersectedAltApps[n2++] = alternateAppearanceRetained;
                        continue block0;
                    }
                    continue;
                }
                this.intersectedBounds[n2] = alternateAppearanceRetained.region;
                this.intersectedAltApps[n2++] = alternateAppearanceRetained;
            }
        }
        return n2;
    }

    void initViewSpecificInfo(J3dMessage j3dMessage) {
        int[] nArray = (int[])j3dMessage.args[2];
        ArrayList arrayList = (ArrayList)j3dMessage.args[1];
        ArrayList arrayList2 = (ArrayList)j3dMessage.args[0];
        if (arrayList2 != null) {
            int n2 = arrayList2.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ViewSpecificGroupRetained viewSpecificGroupRetained = (ViewSpecificGroupRetained)arrayList2.get(i2);
                ArrayList arrayList3 = (ArrayList)arrayList.get(i2);
                int n3 = nArray[i2];
                viewSpecificGroupRetained.cachedViewList.add(n3, arrayList3);
            }
        }
    }

    void clearViewSpecificInfo(J3dMessage j3dMessage) {
        int[] nArray = (int[])j3dMessage.args[1];
        ArrayList arrayList = (ArrayList)j3dMessage.args[0];
        if (arrayList != null) {
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ViewSpecificGroupRetained viewSpecificGroupRetained = (ViewSpecificGroupRetained)arrayList.get(i2);
                int n3 = nArray[i2];
                if (n3 == -1) {
                    int n4 = viewSpecificGroupRetained.cachedViewList.size();
                    for (int i3 = 0; i3 < n4; ++i3) {
                        ArrayList arrayList2 = (ArrayList)viewSpecificGroupRetained.cachedViewList.get(i3);
                        arrayList2.clear();
                    }
                    viewSpecificGroupRetained.cachedViewList.clear();
                    continue;
                }
                ArrayList arrayList3 = (ArrayList)viewSpecificGroupRetained.cachedViewList.remove(n3);
                arrayList3.clear();
            }
        }
    }

    void updateViewSpecificGroupChanged(J3dMessage j3dMessage) {
        Object e2;
        Object object;
        ViewSpecificGroupRetained viewSpecificGroupRetained;
        int n2;
        int n3;
        Object object2;
        Object object3;
        ArrayList arrayList;
        Object object4;
        int n4 = (Integer)j3dMessage.args[0];
        Object[] objectArray = (Object[])j3dMessage.args[1];
        ArrayList arrayList2 = null;
        ArrayList arrayList3 = null;
        ArrayList arrayList4 = null;
        ArrayList arrayList5 = null;
        ArrayList arrayList6 = null;
        ArrayList arrayList7 = null;
        if ((n4 & 2) != 0 || (n4 & 1) != 0) {
            object4 = (View)objectArray[0];
            arrayList = (ArrayList)objectArray[1];
            object3 = (ArrayList)objectArray[2];
            object2 = (int[])objectArray[3];
            n3 = arrayList.size();
            if (object4 != null) {
                for (n2 = 0; n2 < n3; ++n2) {
                    viewSpecificGroupRetained = (ViewSpecificGroupRetained)arrayList.get(n2);
                    object = object2[n2];
                    viewSpecificGroupRetained.updateCachedInformation(2, (View)object4, (int)object);
                }
                n3 = ((ArrayList)object3).size();
                if (n3 > 0) {
                    for (n2 = 0; n2 < n3; ++n2) {
                        e2 = ((ArrayList)object3).get(n2);
                        if (e2 instanceof LightRetained) {
                            ((LightRetained)e2).isViewScoped = true;
                            ++this.numberOfLights;
                            if (arrayList2 == null && (arrayList2 = (ArrayList)this.viewScopedLights.get(object4)) == null) {
                                arrayList2 = new ArrayList();
                                this.viewScopedLights.put(object4, arrayList2);
                            }
                            arrayList2.add(e2);
                        }
                        if (e2 instanceof FogRetained) {
                            ((FogRetained)e2).isViewScoped = true;
                            ++this.numberOfFogs;
                            if (arrayList3 == null && (arrayList3 = (ArrayList)this.viewScopedFogs.get(object4)) == null) {
                                arrayList3 = new ArrayList();
                                this.viewScopedFogs.put(object4, arrayList3);
                            }
                            arrayList3.add(e2);
                        }
                        if (e2 instanceof ModelClipRetained) {
                            ((ModelClipRetained)e2).isViewScoped = true;
                            ++this.numberOfModelClips;
                            if (arrayList4 == null && (arrayList4 = (ArrayList)this.viewScopedModelClips.get(object4)) == null) {
                                arrayList4 = new ArrayList();
                                this.viewScopedModelClips.put(object4, arrayList4);
                            }
                            arrayList4.add(e2);
                        }
                        if (e2 instanceof AlternateAppearanceRetained) {
                            ((AlternateAppearanceRetained)e2).isViewScoped = true;
                            ++this.numberOfAltApps;
                            if (arrayList5 == null && (arrayList5 = (ArrayList)this.viewScopedAltAppearances.get(object4)) == null) {
                                arrayList5 = new ArrayList();
                                this.viewScopedAltAppearances.put(object4, arrayList5);
                            }
                            arrayList5.add(e2);
                        }
                        if (e2 instanceof ClipRetained) {
                            ((ClipRetained)e2).isViewScoped = true;
                            ++this.numberOfClips;
                            if (arrayList7 == null && (arrayList7 = (ArrayList)this.viewScopedClips.get(object4)) == null) {
                                arrayList7 = new ArrayList();
                                this.viewScopedClips.put(object4, arrayList7);
                            }
                            arrayList7.add(e2);
                        }
                        if (!(e2 instanceof BackgroundRetained)) continue;
                        ((BackgroundRetained)e2).isViewScoped = true;
                        ++this.numberOfBgs;
                        if (arrayList6 == null && (arrayList6 = (ArrayList)this.viewScopedBackgrounds.get(object4)) == null) {
                            arrayList6 = new ArrayList();
                            this.viewScopedBackgrounds.put(object4, arrayList6);
                        }
                        arrayList6.add(e2);
                    }
                    if (this.numberOfLights > this.retlights.length) {
                        this.retlights = new LightRetained[this.numberOfLights];
                    }
                    if (this.intersectedFogs.length < this.numberOfFogs) {
                        this.intersectedFogs = new FogRetained[this.numberOfFogs];
                    }
                    if (this.intersectedAltApps.length < this.numberOfAltApps) {
                        this.intersectedAltApps = new AlternateAppearanceRetained[this.numberOfAltApps];
                    }
                    if (this.intersectedBacks.length < this.numberOfBgs) {
                        this.intersectedBacks = new BackgroundRetained[this.numberOfBgs];
                    }
                    if (this.intersectedClips.length < this.numberOfClips) {
                        this.intersectedClips = new ClipRetained[this.numberOfClips];
                    }
                    if (this.intersectedModelClips.length < this.numberOfModelClips) {
                        this.intersectedModelClips = new ModelClipRetained[this.numberOfModelClips];
                    }
                }
            }
        }
        if ((n4 & 4) != 0 || (n4 & 1) != 0) {
            if ((n4 & 4) != 0) {
                object2 = (View)objectArray[0];
                object4 = (ArrayList)objectArray[1];
                arrayList = (ArrayList)objectArray[2];
                object3 = (int[])objectArray[3];
            } else {
                object2 = (View)objectArray[4];
                object4 = (ArrayList)objectArray[5];
                arrayList = (ArrayList)objectArray[6];
                object3 = (int[])objectArray[7];
            }
            if (object2 != null) {
                n3 = ((ArrayList)object4).size();
                for (n2 = 0; n2 < n3; ++n2) {
                    viewSpecificGroupRetained = (ViewSpecificGroupRetained)((ArrayList)object4).get(n2);
                    object = object3[n2];
                    viewSpecificGroupRetained.updateCachedInformation(4, (View)object2, (int)object);
                }
                n3 = arrayList.size();
                if (n3 > 0) {
                    for (n2 = 0; n2 < n3; ++n2) {
                        e2 = arrayList.get(n2);
                        if (e2 instanceof LightRetained) {
                            ((LightRetained)e2).isViewScoped = false;
                            --this.numberOfLights;
                            if (arrayList2 == null) {
                                arrayList2 = (ArrayList)this.viewScopedLights.get(object2);
                            }
                            arrayList2.remove(e2);
                        }
                        if (e2 instanceof FogRetained) {
                            ((FogRetained)e2).isViewScoped = false;
                            --this.numberOfFogs;
                            if (arrayList3 == null) {
                                arrayList3 = (ArrayList)this.viewScopedFogs.get(object2);
                            }
                            arrayList3.remove(e2);
                        }
                        if (e2 instanceof ModelClipRetained) {
                            ((ModelClipRetained)e2).isViewScoped = false;
                            --this.numberOfModelClips;
                            if (arrayList4 == null) {
                                arrayList4 = (ArrayList)this.viewScopedModelClips.get(object2);
                            }
                            arrayList4.remove(e2);
                        }
                        if (e2 instanceof AlternateAppearanceRetained) {
                            ((AlternateAppearanceRetained)e2).isViewScoped = false;
                            --this.numberOfAltApps;
                            if (arrayList5 == null) {
                                arrayList5 = (ArrayList)this.viewScopedAltAppearances.get(object2);
                            }
                            arrayList5.remove(e2);
                        }
                        if (e2 instanceof ClipRetained) {
                            ((ClipRetained)e2).isViewScoped = false;
                            --this.numberOfClips;
                            if (arrayList7 == null) {
                                arrayList7 = (ArrayList)this.viewScopedClips.get(object2);
                            }
                            arrayList7.remove(e2);
                        }
                        if (!(e2 instanceof BackgroundRetained)) continue;
                        ((BackgroundRetained)e2).isViewScoped = false;
                        ++this.numberOfBgs;
                        if (arrayList6 == null) {
                            arrayList6 = (ArrayList)this.viewScopedBackgrounds.get(object2);
                        }
                        arrayList6.remove(e2);
                    }
                    if (arrayList2 != null && arrayList2.size() == 0) {
                        this.viewScopedLights.remove(object2);
                    }
                    if (arrayList3 != null && arrayList3.size() == 0) {
                        this.viewScopedFogs.remove(object2);
                    }
                    if (arrayList4 != null && arrayList4.size() == 0) {
                        this.viewScopedModelClips.remove(object2);
                    }
                    if (arrayList5 != null && arrayList5.size() == 0) {
                        this.viewScopedAltAppearances.remove(object2);
                    }
                    if (arrayList7 != null && arrayList7.size() == 0) {
                        this.viewScopedClips.remove(object2);
                    }
                    if (arrayList6 != null && arrayList6.size() == 0) {
                        this.viewScopedBackgrounds.remove(object2);
                    }
                }
            }
        }
    }

    boolean isLightScopedToThisView(Object object, View view) {
        ArrayList arrayList;
        LightRetained lightRetained = (LightRetained)object;
        return !lightRetained.isViewScoped || (arrayList = (ArrayList)this.viewScopedLights.get(view)) != null && arrayList.contains(lightRetained);
    }

    boolean isFogScopedToThisView(Object object, View view) {
        ArrayList arrayList;
        FogRetained fogRetained = (FogRetained)object;
        return !fogRetained.isViewScoped || (arrayList = (ArrayList)this.viewScopedFogs.get(view)) != null && arrayList.contains(fogRetained);
    }

    boolean isAltAppScopedToThisView(Object object, View view) {
        ArrayList arrayList;
        AlternateAppearanceRetained alternateAppearanceRetained = (AlternateAppearanceRetained)object;
        return !alternateAppearanceRetained.isViewScoped || (arrayList = (ArrayList)this.viewScopedAltAppearances.get(view)) != null && arrayList.contains(alternateAppearanceRetained);
    }

    boolean isBgScopedToThisView(Object object, View view) {
        ArrayList arrayList;
        BackgroundRetained backgroundRetained = (BackgroundRetained)object;
        return !backgroundRetained.isViewScoped || (arrayList = (ArrayList)this.viewScopedBackgrounds.get(view)) != null && arrayList.contains(backgroundRetained);
    }

    boolean isClipScopedToThisView(Object object, View view) {
        ArrayList arrayList;
        ClipRetained clipRetained = (ClipRetained)object;
        return !clipRetained.isViewScoped || (arrayList = (ArrayList)this.viewScopedClips.get(view)) != null && arrayList.contains(clipRetained);
    }

    boolean isMclipScopedToThisView(Object object, View view) {
        ArrayList arrayList;
        ModelClipRetained modelClipRetained = (ModelClipRetained)object;
        return !modelClipRetained.isViewScoped || (arrayList = (ArrayList)this.viewScopedModelClips.get(view)) != null && arrayList.contains(modelClipRetained);
    }

    void cleanup() {
    }
}

